package org.apache.jackrabbit.ocm.model;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.jackrabbit.ocm.mapper.impl.annotation.Bean;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.Collection;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.Field;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.Node;

@Node
public class PressRelease
{
	@Field(path=true) private String path;
	@Field  private String title;
	@Field  private Date pubDate;
	@Field  private String content;
	@Bean private Author author;
	@Collection  List<Url> urls;
	
	//if you want a map instead of a list, use the following declaration
	@Collection Map<String,Url> map;


	public String getPath() {
		return path;
	}
	public void setPath(String path) {
		this.path = path;
	}
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		this.content = content;
	}
	public Date getPubDate() {
		return pubDate;
	}
	public void setPubDate(Date pubDate) {
		this.pubDate = pubDate;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public Author getAuthor() {
		return author;
	}
	public void setAuthor(Author author) {
		this.author = author;
	}
	public List<Url> getUrls() {
		return urls;
	}
	public void setUrls(List<Url> urls) {
		this.urls = urls;
	}
	public Map<String, Url> getMap() {
		return map;
	}
	public void setMap(Map<String, Url> map) {
		this.map = map;
	}

}
