package org.apache.jackrabbit.ocm.model;

import org.apache.jackrabbit.ocm.mapper.impl.annotation.Field;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.Node;

/**
 * Simple Pojo used to store information on a URL.
 *
 */

@Node
public class Url {

	@Field(path=true) String path;
	@Field String url;
	@Field String description;
	@Field String caption;

	/**
	 * no arg constructor required by the OCM
	 */
	public Url() {
		super();

	}


	public Url(String url, String description, String caption) {
		super();
		this.url = url;
		this.description = description;
		this.caption = caption;
	}

	public String getPath() {
		return path;
	}


	public void setPath(String path) {
		this.path = path;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public String getCaption() {
		return caption;
	}
	public void setCaption(String caption) {
		this.caption = caption;
	}

}
