/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.jboss;

import java.io.FileInputStream;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJbossAccessManager
implements AccessManager {
    private static Logger log = LoggerFactory.getLogger(SimpleJbossAccessManager.class);
    protected Subject subject;
    protected HierarchyManager hierMgr;
    private boolean initialized = false;
    protected boolean system = false;
    protected boolean anonymous = false;

    public void init(AMContext context) throws AccessDeniedException, Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.subject = context.getSubject();
        this.hierMgr = context.getHierarchyManager();
        Set<Principal> ps = this.subject.getPrincipals();
        Properties rolemaps = new Properties();
        String rolemaploc = context.getHomeDir() + "/rolemappings.properties";
        FileInputStream rolefs = new FileInputStream(rolemaploc);
        rolemaps.load(rolefs);
        rolefs.close();
        log.info("Load jbossgroup role mappings from " + rolemaploc);
        for (Principal p : ps) {
            if (!p.getName().equalsIgnoreCase("Roles")) continue;
            SimpleGroup sg = (SimpleGroup)p;
            Enumeration em = sg.members();
            while (em.hasMoreElements()) {
                SimplePrincipal myp = (SimplePrincipal)em.nextElement();
                String role = rolemaps.getProperty(myp.getName());
                if (role != null && role.equalsIgnoreCase("full")) {
                    this.system = true;
                    continue;
                }
                if (role == null || !role.equalsIgnoreCase("read")) continue;
                this.anonymous = true;
            }
        }
        this.initialized = true;
    }

    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        this.initialized = false;
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (this.system) {
            return;
        }
        if (this.anonymous) {
            if ((permissions & 2) == 2 || (permissions & 4) == 4) {
                throw new AccessDeniedException();
            }
        } else {
            throw new AccessDeniedException();
        }
    }

    public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (this.system) {
            return true;
        }
        if (this.anonymous) {
            return (permissions & 2) != 2 && (permissions & 4) != 4;
        }
        return false;
    }

    public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        return this.system || this.anonymous;
    }
}

