package org.apache.jackrabbit.ocm.exception;


/**
 * Occurs when it is not possible to manage the JCR repository (register, login, ...)
 *
 * @author <a href="mailto:christophe.lombart@gmail.com">Christophe Lombart</a>
 */

public class RepositoryException extends NestableRuntimeException {
    /** Use serialVersionUID for interoperability. */
    private final static long serialVersionUID = 910346108378604638L;

    /**
     * No-arg constructor used by markup exceptions.
     */
    protected RepositoryException() {
    }

    /**
     * Constructor with message.
     *
     * @param message the message associated to the exception
     */
    public RepositoryException(String message) {
        super(message);
    }

    /**
     * Constructor with throwable object.
     *
     * @param nested the associated throwable object
     */
    public RepositoryException(Throwable nested) {
        super(nested);
    }

    /**
     * Constructor with message and throwable object.
     *
     * @param message the message associated to the exception
     * @param nested the associated throwable object
     */
    public RepositoryException(String message, Throwable nested) {
        super(message, nested);
    }

}
