package org.apache.jackrabbit.ocm.model;

import org.apache.jackrabbit.ocm.mapper.impl.annotation.Field;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.Node;

/**
 * Simple Pojo used to store information on a author.
 *
 * Note : the path field is not mandatory because an Author
 * is an aggregation of a PressRelease.
 *
 */
@Node
public class Author {

	@Field private String firstName;
	@Field private String lastName;

	/**
	 * no arg constructor required by Jackrabbit OCM
	 */
	public Author() {
		super();
	}

	public Author(String firstName, String lastName) {

		this.firstName = firstName;
		this.lastName = lastName;
	}

	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}


}
