/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.ocm.util;

import java.io.IOException;
import java.util.Hashtable;

import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.naming.Context;
import javax.naming.InitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.jndi.RegistryHelper;
import org.apache.jackrabbit.ocm.exception.RepositoryException;

/**
 * Utility class for managing JCR repositories.
 * <b>Note</b>: most of the utility methods in this class can be used only with Jackrabbit.
 *
 * @author <a href="mailto:christophe.lombart@sword-technologies.com">Lombart Christophe </a>
 * @version $Id: Exp $
 */
public class RepositoryUtil {

	/** Item path separator */
	public static final String PATH_SEPARATOR = "/";

	private final static Log log = LogFactory.getLog(RepositoryUtil.class);


	public static Repository getTrancientRepository()
	{
		  try {
			return new TransientRepository();
		} catch (IOException e) {
			throw new RepositoryException(
					"Impossible to register the respository ",
					e);
		}

	}
	


	/**
	 * Connect to a JCR repository
	 *
	 * @param repository The JCR repository
	 * @param user The user name
	 * @param password The password
	 * @return a valid JCR session
	 *
	 * @throws RepositoryException when it is not possible to connect to the JCR repository
	 */
	public static Session login(Repository repository, String user,
			String password) throws RepositoryException {
		try {
			Session session = repository.login(new SimpleCredentials(user,
					password.toCharArray()), null);

			return session;
		} catch (Exception e) {
			throw new RepositoryException("Impossible to login ", e);

		}

	}

	public static Session login(Repository repository, String user,
			String password, String workspace) throws RepositoryException {
		try {
			Session session = repository.login(new SimpleCredentials(user,
					password.toCharArray()), workspace);
			return session;
		} catch (Exception e) {
			throw new RepositoryException("Impossible to login ", e);

		}

	}


}
